#!/bin/sh

# Checking root access

if [ "$(id -u)" != "0" ]; then
    echo "This script must be run as root"
    exit 1
fi

Service=`command -v service`
$Service licenceserver stop

if [ "$(pidof systemd)" ]; then

	systemctl disable licenceserver

elif [ "$(pidof /sbin/init)" ]; then

	if command -v chkconfig >/dev/null 2>&1; then
		chkconfig --del licenceserver
	elif command -v update-rc.d >/dev/null 2>&1; then
		update-rc.d licenceserver remove -f 
	fi

fi

if [ -f /lib/systemd/system/licenceserver.service ]; then
	rm -f /lib/systemd/system/licenceserver.service
fi

if [ -f /etc/init.d/licenceserver ]; then
	rm -f /etc/init.d/licenceserver
fi

